//
//  CRInplaceEditorMask.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 1/22/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRCICanvas.h"
#import "CRInplaceEditor.h"

extern NSString* const CRCanvasPasteboardType;

//////////////////////////////////////////////////////////////////////
// Inplace mask editor
// Required 'rootObject' to be CRCICanvas instance
//////////////////////////////////////////////////////////////////////
typedef enum {
	CRMaskToolBrush = 0,
	CRMaskToolEraser,
} CRMaskToolIndex;

@interface CRInplaceEditorMask : CRInplaceEditor
{
	BOOL		mouseInside;
	BOOL		paintStarted;
	NSInteger	selectedTool;
	BOOL		preventMouse;
	NSPoint		mouseLocation;
	
	NSPoint		lastPoint;
	NSColor*	drawColor;
	
	CGFloat		radius;
	CGFloat		opacity;
	CGFloat		flow;
	
	NSCursor*	emptyCursor;
	CIImage*	circleImage;
}

@property (nonatomic, assign) CGFloat	radius;
@property (nonatomic, assign) CGFloat	opacity;
@property (nonatomic, assign) CGFloat	flow;
@property (nonatomic, assign) NSInteger	selectedTool;

- (CGFloat)minRadius;
- (CGFloat)maxRadius;
- (CGFloat)minOpacity;
- (CGFloat)maxOpacity;
- (CGFloat)minFlow;
- (CGFloat)maxFlow;

- (CRCICanvas *)canvas;
- (void)fillCanvas:(NSColor *)color;

- (void)copy:(id)sender;
- (void)paste:(id)sender;

- (IBAction)increaseBrushSize:(id)sender;
- (IBAction)decreaseBrushSize:(id)sender;

@end